{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 07.01.99 - 10:29:01 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, MMWave, MMObj, MMUtils, MMWheel, Mask, ExtCtrls, MMVolume, MMConect,
  MMRingBf, MMWMixer, MMDSPObj, MMWavOut, MMHTimer, MMDesign, MMDIBCv,
  MMLevel, MMCstDlg, MMDSPMtr, MMLEDS, MMACMCvt, MMHook, MMAudio;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Timer: TMMHiTimer;
    btnStop: TButton;
    btnStart: TButton;
    WaveOut: TMMWaveOut;
    WaveMixer: TMMWaveMixer;
    TimeLabel: TLabel;
    Level1: TMMLevel;
    Connector: TMMConnector;
    Level2: TMMLevel;
    ckbLevel: TCheckBox;
    Label2: TLabel;
    lblDropOuts: TLabel;
    Panel1: TPanel;
    Volume1: TMMWheel;
    Label5: TLabel;
    Label6: TLabel;
    Panning1: TMMWheel;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    Label8: TLabel;
    PanningMaster: TMMWheel;
    Panel2: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    Volume2: TMMWheel;
    Panning2: TMMWheel;
    Panel3: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Volume3: TMMWheel;
    Panning3: TMMWheel;
    Panel4: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Volume4: TMMWheel;
    Panning4: TMMWheel;
    MasterVolume: TMMVolume;
    ckbLoop1: TCheckBox;
    ckbLoop2: TCheckBox;
    ckbLoop3: TCheckBox;
    ckbLoop4: TCheckBox;
    FilePanel1: TPanel;
    btnFile1: TButton;
    FName1: TLabel;
    FilePanel2: TPanel;
    btnFile2: TButton;
    FName2: TLabel;
    FilePanel3: TPanel;
    btnFile3: TButton;
    FName3: TLabel;
    FilePanel4: TPanel;
    btnFile4: TButton;
    FName4: TLabel;
    Label1: TLabel;
    DSPLabel: TLabel;
    LED1: TMMLED;
    LED2: TMMLED;
    LED3: TMMLED;
    LED4: TMMLED;
    Label4: TLabel;
    lblPos4: TLabel;
    Label10: TLabel;
    lblPos3: TLabel;
    Label18: TLabel;
    lblPos2: TLabel;
    Label22: TLabel;
    lblPos1: TLabel;
    DSPMeter: TMMDSPMeter;
    btnStop1: TButton;
    btnStop2: TButton;
    btnStop3: TButton;
    btnStop4: TButton;
    AudioFile1: TMMAudioFile;
    AudioFile2: TMMAudioFile;
    AudioFile3: TMMAudioFile;
    AudioFile4: TMMAudioFile;
    OpenDialog: TOpenDialog;
    btnPlay1: TButton;
    btnPlay2: TButton;
    btnPlay3: TButton;
    btnPlay4: TButton;
    btnFade1: TButton;
    btnFade2: TButton;
    btnFade3: TButton;
    btnFade4: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure btnLoadFileClick(Sender: TObject);
    procedure ckbLevelClick(Sender: TObject);
    procedure RingBufferEmpty(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure PanningChange(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure PanningMasterChange(Sender: TObject);
    procedure ckbLoopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnPlayFileClick(Sender: TObject);
    procedure btnStopFile(Sender: TObject);
    procedure btnFadeClick(Sender: TObject);
  private
    DropOuts: Longint;
    TimeCounter: Longint;
    Files: array[0..3] of string;
  public
    procedure UpdateFileLabel(Tag: integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// NOTE: Maximal playbacktime of TMMWaveOut is ~3.5 hours, then it will stop.
//       The Windows MMSystem works with 32 bit positions and they will overflow
//       if the 32 bit value is wrapped so we stop the device. It's always a good
//       idea to close and restart the device every 2-3 hours.

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer.Enabled := False;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   TimeCounter := 0;
   Timer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;
   DSPLabel.Caption := '0 %';
   LED1.Enabled := False;
   LED2.Enabled := False;
   LED3.Enabled := False;
   LED4.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   DropOuts := 0;
   WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
begin
   TimeLabel.Caption := TimeToString64(WaveOut.Position,WaveOut.PositionHigh,True);

   inc(TimeCounter);
   if (Timer.Interval*TimeCounter >= 500) then
   begin
      TimeCounter := 0;
      DSPLabel.Caption := IntToStr(DSPMeter.Value)+' %';

      LED1.Enabled := WaveMixer.InputLoading[0];
      LED2.Enabled := WaveMixer.InputLoading[1];
      LED3.Enabled := WaveMixer.InputLoading[2];
      LED4.Enabled := WaveMixer.InputLoading[3];

      lblPos1.Caption := TimeToString64Ex(WaveMixer.InputPosition[0],True);
      lblPos2.Caption := TimeToString64Ex(WaveMixer.InputPosition[1],True);
      lblPos3.Caption := TimeToString64Ex(WaveMixer.InputPosition[2],True);
      lblPos4.Caption := TimeToString64Ex(WaveMixer.InputPosition[3],True);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RingBufferEmpty(Sender: TObject);
begin
   inc(DropOuts);
   lblDropOuts.Caption := IntToStr(DropOuts);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLevelClick(Sender: TObject);
begin
   Connector.Enabled := ckbLevel.Checked;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.UpdateFileLabel(Tag: integer);
begin
   case Tag of
      0: FName1.Caption := MinimizeName(Files[Tag],FName1.Canvas,FName1.Width);
      1: FName2.Caption := MinimizeName(Files[Tag],FName2.Canvas,FName2.Width);
      2: FName3.Caption := MinimizeName(Files[Tag],FName3.Canvas,FName3.Width);
      3: FName4.Caption := MinimizeName(Files[Tag],FName4.Canvas,FName4.Width);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnLoadFileClick(Sender: TObject);
var
   idx: integer;
begin
   if OpenDialog.Execute then
   begin
      idx := TControl(Sender).Tag;
      case idx of
         0: begin
               { mark this channel as done }
               WaveMixer.InputDone[0] := True;
               { set the new filename }
               AudioFile1.FileName    := '';
               Files[idx]             := OpenDialog.FileName;
            end;
         1: begin
               WaveMixer.InputDone[1] := True;
               AudioFile2.FileName    := '';
               Files[idx]             := OpenDialog.FileName;
            end;
         2: begin
               WaveMixer.InputDone[2] := True;
               AudioFile3.FileName    := '';
               Files[idx]             := OpenDialog.FileName;
            end;
         3: begin
               WaveMixer.InputDone[3] := True;
               AudioFile4.FileName    := '';
               Files[idx]             := OpenDialog.FileName;
            end;
      end;
      UpdateFileLabel(TControl(Sender).Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopFile(Sender: TObject);
var
   idx: integer;
begin
   idx := TControl(Sender).Tag;
   case idx of
      0: begin
            { mark this channel as done }
            WaveMixer.InputDone[0] := True;
            AudioFile1.FileName    := '';
         end;
      1: begin
            WaveMixer.InputDone[1] := True;
            AudioFile2.FileName    := '';
         end;
      2: begin
            WaveMixer.InputDone[2] := True;
            AudioFile3.FileName    := '';
         end;
      3: begin
            WaveMixer.InputDone[3] := True;
            AudioFile4.FileName    := '';
         end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnPlayFileClick(Sender: TObject);
var
   idx: integer;
begin
   idx := TControl(Sender).Tag;
   case idx of
      0: begin
            { enable this channel }
            AudioFile1.FileName    := Files[idx];
            WaveMixer.InputDone[0] := False;
         end;
      1: begin
            AudioFile2.FileName    := Files[idx];
            WaveMixer.InputDone[1] := False;
         end;
      2: begin
            AudioFile3.FileName    := Files[idx];
            WaveMixer.InputDone[2] := False;
         end;
      3: begin
            AudioFile4.FileName    := Files[idx];
            WaveMixer.InputDone[3] := False;
         end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFadeClick(Sender: TObject);
var
   idx: integer;
begin
   idx := TControl(Sender).Tag;
   case idx of
      0: begin
            // make 3 sec FadeOut
            AudioFile1.FadeOut(3000);
         end;
      1: begin
            AudioFile2.FadeOut(3000);
         end;
      2: begin
            AudioFile3.FadeOut(3000);
         end;
      3: begin
            AudioFile4.FadeOut(3000);
         end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Volume := Volume1.Value;
      1: AudioFile2.Volume := Volume2.Value;
      2: AudioFile3.Volume := Volume3.Value;
      3: AudioFile4.Volume := Volume4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Panning := Panning1.Value;
      1: AudioFile2.Panning := Panning2.Value;
      2: AudioFile3.Panning := Panning3.Value;
      3: AudioFile4.Panning := Panning4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningMasterChange(Sender: TObject);
begin
   MasterVolume.Panning := PanningMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.Loop1 := ckbLoop1.Checked;
       1: WaveMixer.Loop2 := ckbLoop2.Checked;
       2: WaveMixer.Loop3 := ckbLoop3.Checked;
       3: WaveMixer.Loop4 := ckbLoop4.Checked;
   end;
end;


end.
